/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.node;

import java.util.Map;
import org.drools.common.InternalKnowledgeRuntime;
import org.drools.definition.process.Process;
import org.drools.event.ProcessEventSupport;
import org.drools.process.instance.WorkItemManager;
import org.drools.process.instance.impl.WorkItemImpl;
import org.drools.runtime.KnowledgeRuntime;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.process.instance.ProcessInstance;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.jbpm.workflow.instance.node.DynamicNodeInstance;
import org.jbpm.workflow.instance.node.SubProcessNodeInstance;
import org.jbpm.workflow.instance.node.WorkItemNodeInstance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicUtils {
    public static void addDynamicWorkItem(DynamicNodeInstance dynamicContext, KnowledgeRuntime ksession, String workItemName, Map<String, Object> parameters) {
        WorkflowProcessInstance processInstance = dynamicContext.getProcessInstance();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setState(1);
        workItem.setProcessInstanceId(processInstance.getId());
        workItem.setName(workItemName);
        workItem.setParameters(parameters);
        WorkItemNodeInstance workItemNodeInstance = new WorkItemNodeInstance();
        workItemNodeInstance.setNodeInstanceContainer(dynamicContext);
        workItemNodeInstance.setProcessInstance(processInstance);
        workItemNodeInstance.internalSetWorkItem(workItem);
        workItemNodeInstance.addEventListeners();
        ProcessEventSupport eventSupport = ((InternalProcessRuntime)((InternalKnowledgeRuntime)ksession).getProcessRuntime()).getProcessEventSupport();
        eventSupport.fireBeforeNodeTriggered(workItemNodeInstance, ksession);
        ((WorkItemManager)ksession.getWorkItemManager()).internalExecuteWorkItem(workItem);
        eventSupport.fireAfterNodeTriggered(workItemNodeInstance, ksession);
    }

    public static void addDynamicSubProcess(DynamicNodeInstance dynamicContext, KnowledgeRuntime ksession, String processId, Map<String, Object> parameters) {
        WorkflowProcessInstance processInstance = dynamicContext.getProcessInstance();
        SubProcessNodeInstance subProcessNodeInstance = new SubProcessNodeInstance();
        subProcessNodeInstance.setNodeInstanceContainer(dynamicContext);
        subProcessNodeInstance.setProcessInstance(processInstance);
        Process process = ksession.getKnowledgeBase().getProcess(processId);
        if (process == null) {
            System.err.println("Could not find process " + processId);
            System.err.println("Aborting process");
            processInstance.setState(3);
        } else {
            ProcessEventSupport eventSupport = ((InternalProcessRuntime)((InternalKnowledgeRuntime)ksession).getProcessRuntime()).getProcessEventSupport();
            eventSupport.fireBeforeNodeTriggered(subProcessNodeInstance, ksession);
            ProcessInstance subProcessInstance = (ProcessInstance)ksession.startProcess(processId, parameters);
            eventSupport.fireAfterNodeTriggered(subProcessNodeInstance, ksession);
            if (subProcessInstance.getState() == 2) {
                subProcessNodeInstance.triggerCompleted();
            } else {
                subProcessNodeInstance.internalSetProcessInstanceId(subProcessInstance.getId());
                subProcessNodeInstance.addEventListeners();
            }
        }
    }
}

